//%attributes = {"invisible":true}
/*

目的：リモート接続した４Ｄで4D Serverで生成されたデータを受け取りファイルにする

*/

#DECLARE($window : Integer; $selection : cs:C1710.TableTestSelection; $file : 4D:C1709.File)

Case of 
	: (Current process name:C1392#Current method name:C684)
		
		//mark: 非同期で動作
		CALL WORKER:C1389(Current method name:C684; Current method name:C684; $window; $selection; $file)
		
		
		
		//mark:-
	: ($selection.getDataClass().textForListboxEx#Null:C1517)
		
		//mark: スタンドアローンのクライアントのとき（ファイルに書き出すデータをREST経由でBLOBに受け取る）
		
		var $blob : Blob
		$blob:=$selection.exportToBlobEx()
		
		//mark: ファイルに書き出し
		$file.setContent($blob)
		
		//mark: 書き出し終了
		If (Window process:C446($window)=0)
			
			//mark: 指定されたウィンドウが無い
			ALERT:C41("ファイルに書き出しました")
			
		Else 
			
			CALL FORM:C1391($window; Formula:C1597(OBJECT SET TITLE:C194(*; "Text message"; "ファイルに書き出しが終了しました")))
			
		End if 
		
		KILL WORKER:C1390
		
		
		//mark:-
	Else 
		
		//mark: リモート接続のクライアントのとき（ファイルに書き出すデータを4Dプロトコル経由でBLOBに受け取る）
		
		var $blob : Blob
		$blob:=$selection.exportToBLOB()
		
		//mark: ファイルに書き出し
		$file.setContent($blob)
		
		//mark: 書き出し終了
		If (Window process:C446($window)=0)
			
			//mark: 指定されたウィンドウが無い
			ALERT:C41("ファイルに書き出しました")
			
		Else 
			
			CALL FORM:C1391($window; Formula:C1597(OBJECT SET TITLE:C194(*; "Text message"; "ファイルに書き出しが終了しました")))
			
		End if 
		
		KILL WORKER:C1390
		
		
End case 